import { Link, useLocation } from 'react-router-dom'
import { motion } from 'framer-motion'
import { Video } from 'lucide-react'
import Footer from './Footer'
import './Layout.css'

const Layout = ({ children }) => {
  const location = useLocation()

  return (
    <div className="app-wrapper-tech">
      <header className="header-tech">
        <div className="container">
          <div className="header-content-tech">
            <Link to="/" className="logo-tech">
              <div className="logo-icon-tech">
                <Video size={24} strokeWidth={2.5} />
              </div>
              <span className="logo-text-tech">EditPro</span>
            </Link>
            <nav className="nav-tech">
              <Link 
                to="/" 
                className={`nav-link-tech ${location.pathname === '/' ? 'active' : ''}`}
              >
                Мои проекты
              </Link>
              <Link 
                to="/enroll" 
                className={`nav-link-tech ${location.pathname === '/enroll' ? 'active' : ''}`}
              >
                Записаться
              </Link>
            </nav>
          </div>
        </div>
      </header>

      <main className="main-content-tech">
        {children}
      </main>

      <Footer />
    </div>
  )
}

export default Layout

